#!/bin/sh
#
#
PROG=ups_netcomm
INSTALL_DIR=`pwd`
PROGRAM_DIR=/etc/ups_safemate/

echo "Linux INSTALL FOR ups_safemate"
#----------------------------------------------------
#	Must run this script as root
#----------------------------------------------------
uid=`id | sed 's/^uid=\([0-9][0-9]*\).*$/\1/'`
if [ $uid -ne 0 ]; then
    echo "Not logged in as root."
    exit 1
fi

#-------------------------------------------------------
#	Check source files
#----------------------------------------------------
# SendMSG.sh
# TimeCfg.conf
# config
# install.linux.sh
# shutdown.sh
# startup.add
# ups_netcomm
# ups_status
#-------------------------------------------------------
if [ ! -s $INSTALL_DIR/ups_netcomm ];then
	echo "Missing File Error: $INSTALL_DIR/ups_netcomm does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/ups_status ];then
	echo "Missing File Error: $INSTALL_DIR/ups_status does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/ups_config ];then
	echo "Missing File Error: $INSTALL_DIR/ups_config does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/shutdown.sh ];then
	echo "Missing File Error: $INSTALL_DIR/shutdown.sh does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/SendMSG.sh ];then
	echo "Missing File Error: $INSTALL_DIR/SendMSG.sh does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/startup.add ];then
        echo "Missing File Error: $INSTALL_DIR/startup.add does not exist."
	exit 2
fi
#	==============================================================/
#	Figure out what sort of unix this is
#	==============================================================/
UNAME=""
if [ -f /usr/bin/uname ]; then
	UNAME=`/usr/bin/uname`
fi
if [ -f /bin/uname ];	then
	UNAME=`/bin/uname`
fi
if [ $UNAME = "Linux" ]; then
		echo "Your OS is $UNAME."
else
	echo "OS ERROR: The detected OS is $UNAME, these programs need to run under Linux."
	exit 1
fi
#==============================================================/
#Check and backup previous installation if exists.
#if the previously  installed was found then warnning user and exit the install program.;
#
#    ==============================================================/

echo "ups_safemate will be installed to the directory $PROGRAM_DIR."

if [ -d ${PROGRAM_DIR} ];then

	echo "A previously installed ups_safemate was found. Please run then Installation program after stop it and remove it!"
	exit 1
fi
#=========================vicly add this =====================================/
#Start copy  file
#==============================================================/
{
	if [ ! -d $PROGRAM_DIR ]; then
	echo ""
	echo "Create $PROGRAM_DIR directory..."
	mkdir $PROGRAM_DIR
	fi
	cd $PROGRAM_DIR
	echo ""
        echo -n "Moving files from $INSTALL_DIR to $PROGRAM_DIR "
        cp $INSTALL_DIR/ups_netcomm $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo " "
			echo "Please stop the ups_netcomm background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/ups_status $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo " "
			echo "Please stop the ups_netcomm background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/ups_config $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo ""
			echo "Please stop the ups_netcomm background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/TimeDfg.conf $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/shutdown.sh $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/Readme $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/ups_safemate $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/SendMSG.sh $PROGRAM_DIR 2> /dev/null
		echo -n "."

        echo "OK."
        chmod 544 $PROGRAM_DIR/ups_netcomm 2> /dev/null
        chmod 544 $PROGRAM_DIR/ups_status 2> /dev/null
        chmod 544 $PROGRAM_DIR/ups_config 2> /dev/null

        chmod 744 $PROGRAM_DIR/shutdown.sh 2> /dev/null
        chmod 744 $PROGRAM_DIR/SendMSG.sh 2> /dev/null
	chmod 644 $PROGRAM_DIR/Readme 2> /dev/null
}
#	=========================vicly add this =====================================/
#	Operation after copy file finished
#	Add the start command into the rc.local ,so it will be  start when the system startup.
#	========================================================================================/

{
echo ""
	case `uname -a` in
	*18.04*Ubuntu*)
		#mode 1
		if [ ! -f /etc/systemd/system/rc-local.service ] ; then
			ln -fs /lib/systemd/system/rc-local.service /etc/systemd/system/rc-local.service
			echo "#sitemate install" >> /lib/systemd/system/rc-local.service
			echo "[Install]" >> /lib/systemd/system/rc-local.service
			echo "WantedBy=multi-user.target" >> /lib/systemd/system/rc-local.service
			echo "Alias=rc-local.service" >> /lib/systemd/system/rc-local.service
			echo "#!/bin/sh -e" > /etc/rc.local
			echo "# By default this script does nothing." >> /etc/rc.local
			echo "" >> /etc/rc.local
			echo "exit 0" >> /etc/rc.local

			chmod +x /etc/rc.local
		fi
		#mode 2
		#if [ ! -f /etc/init.d/rc.local ] ; then
		#	echo "#!/bin/sh -e" > /etc/init.d/rc.local
		#	echo "# By default this script does nothing." >> /etc/init.d/rc.local
		#	echo "" >> /etc/init.d/rc.local
		#	echo "exit 0" >> /etc/init.d/rc.local
		#	ln -fs /etc/init.d/rc.local  /etc/rc.local
		#	chmod +x /etc/init.d/rc.local /etc/rc.local
		#	update-rc.d rc.local start 99 2 3 4 5 . stop 99 0 1 6 .
		#fi
		;;
	esac

	if [ -f /etc/rc.d/rc.local ] ; then
		STARTUP=/etc/rc.d/rc.local
	elif [ -f /etc/rc.local ] ; then
		STARTUP=/etc/rc.local
	fi

	STARTUP_ADD=${INSTALL_DIR}/startup.add
	echo "Adding entries in $STARTUP ...."

	rm $INSTALL_DIR/startup.tmp* 2> /dev/null
	sed 's/#\/etc\/ups_safemate/# \/etc\/ups_safemate/' $STARTUP > $INSTALL_DIR/startup.tmp1
	difference=""
	difference=`grep /etc/ups_safemate $STARTUP | awk 'index($1,"if")==0 && index($1,"#")==0 {print $1}' | head -1`
	echo "the difference is :"
	echo $difference
	if [ $difference ]; then
		echo "Found an old version for ups_safemate installation in $STARTUP startup file:"
		difference=`grep -n /etc/ups_safemate $STARTUP | awk 'index($1,"if")==0&&index($1,"#")==0 {print}'`
		echo "LINE $difference"
		answer=""
		while true
		do
			answer=""
			echo -n "Would you like the installation program to remark it for you? (Y)es, (N)o. [y] "
			read answer

			if [ $answer ]; then
				echo ""
			else
				answer="y"
			fi
			if [ $answer = "y" ] || [ $answer = "Y" ]; then
				cat $INSTALL_DIR/startup.tmp1 | awk '{if (index($0,"/etc/ups_safemate") != 0 && $1 != "if" && $1 != "#") printf("# "); print}' >> $INSTALL_DIR/startup.tmp2
				cp $INSTALL_DIR/startup.tmp2 $STARTUP
				break
			elif [ $answer != "n" ] && [ $answer != "N" ]; then
				echo "Invalid Input"
			else
				echo "WARNING: More than one entry point of ups_safemate in $STARTUP, remark or delete them after installation!"
				break
			fi

		done
		echo ""
		echo "Backup $STARTUP to ${STARTUP}.old.ups_safemate."
		cp $STARTUP ${STARTUP}.old.ups_safemate
		else
			echo ""
			echo "Backup $STARTUP to ${STARTUP}.old.ups_safemate"
			cp $STARTUP ${STARTUP}.old.ups_safemate
		fi

		echo "Adding startup command to $STARTUP startup file."

		case $STARTUP in
		  "/etc/rc.local")
		  	#Ubuntu 16.04ϵͳ
			sed -i "/# By default this script does nothing./ r ${STARTUP_ADD}" $STARTUP
			#echo "sed -i '/# By default this script does nothing./ r ${STARTUP_ADD}' $STARTUP"
			;;
		 *)
			cat $STARTUP_ADD >> $STARTUP
			#echo "$STARTUP.............."
		esac
		rm $INSTALL_DIR/startup.tmp* 2> /dev/null
echo "OK."
echo "Press ENTER to continue..."
read answer
sleep 2
}

#	=========================vicly add this =====================================/
#	Last operate after copy file finished
#	==============================================================/
{
  cd ${PROGRAM_DIR}
  echo ""
  echo "Configure the parameter."
  sleep 1
  ${PROGRAM_DIR}/ups_config
  sleep 2

echo "Installation completed!"
  echo ""
  echo " Start UPS PowerManager Monitor background process... "

  ${PROGRAM_DIR}/ups_netcomm &
}

cd $INSTALL_DIR

sleep 1
exit 0
